#include "string.h"
#include "AudioStack/clStackRules.h"
#include "AudioStack/AudioSources.h"
#include "AudioStack/clAudioSource.h"


#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clStackRules.cpp.trc.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES_FUNCTIONIDS
/* Include server interface */
#include "midw_fi_if.h"

/* sources - qualifier */
#define NOT(a) (a | 0x0800)
#define KICK(a) (a | 0x1000)

/* sources - checker */
#define CHECK_NOT(a) (a & NOT(0))
#define CHECK_KICK(a)   (a & KICK(0))
#define MASK(a) (a & 0x07ff)

/* sources */
// not using defines are ...... removed for lint

//#define SRC_Click       17     //lint !e750 PQM_authorized_multi_266  Intentionally not corrected, reviewed and not critical  //lint !e830 PQM_authorized_multi_263  Intentionally not corrected, reviewed and not critical
//#define SRC_Beep        18     //lint !e750 PQM_authorized_multi_266  Intentionally not corrected, reviewed and not critical  //lint !e830 PQM_authorized_multi_263  Intentionally not corrected, reviewed and not critical
/* sources - specials */
#define SRC_END      0xff
#define SRC_ALL      0xfe

/* actions */
#define ACTION_ABORT(a)    (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/action_abort)
// comment out until not used to make Lint happy
//#define ACTION_SETRULE(a)   (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/newRule) /* not implemented */
#define ACTION_END         (clStackRules::/*actions_t::*/end)
#define ACTION_WAIT_FOR(a) (clStackRules::actions_t)(a | clStackRules::/*actions_t::*/action_waitFor)

using namespace am;

namespace AudioStack
{

 clStackRules::rules_t clStackRules::rules[] = {
   //"none", //00,
   {AudioSources::NONE,  static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeBg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
        /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
        /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
        /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
        /*MIX  */ {SRC_END}},             //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //"radioFM1", //01
   {AudioSources::TUNER_FM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_FM), clStackRules::typeBg, clStackRules::groupRadio, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical


   //"radioAM1",//02
   {AudioSources::TUNER_AM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_AM), clStackRules::typeBg, clStackRules::groupRadio, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //"radioDAB",//03
   {AudioSources::TUNER_DAB, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_DAB), clStackRules::/*type_t::*/typeBg, clStackRules::groupRadio, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //"sdComp",//04
   {AudioSources::MEDIA_SD_1,  static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 05
   {AudioSources::MEDIA_BTAUDIO_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 06
   {AudioSources::AUX, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_AUX), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 07
   {AudioSources::AUX_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_AUX), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 08
   {AudioSources::AUX_2, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_AUX), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 09
   {AudioSources::TUNER_TA_FM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_FM_TA), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::PHONE_1, AudioSources::PHONE_OUTBAND_RING, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_AUDIO_OFF,  AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},  //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 10
   {AudioSources::NAVI_SPEECH, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NAVI), clStackRules::typeMix,clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ { AudioSources::MUTE_SYSTEM, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_PIN, SRC_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::PHONE_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_PHONE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::PHONE, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_PHONE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerDynamic, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::PHONE_ECALL, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_PHONE_ECALL), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::PHONE_EXTERNAL_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_PHONE_ANALOG_EXT), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::PHONE_INBAND_RING, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_PHONE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerDynamic, 5, TRUE, NULL,
         /*RULES*/ {AudioSources::PHONE_1, AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
         /*PUSH */ {ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
         /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
         /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 11
   {AudioSources::MEDIA_CDDA, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CDDA), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_ABORT(AudioSources::SMS_SPEECH), ACTION_END},         //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_ENTERTAIN, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::SMS_SPEECH, AudioSources::SPI_PHONE, AudioSources::SDS_SPEECHRECOGNITION, AudioSources::MUTE_SYSTEM, AudioSources::TUNER_TA_FM, AudioSources::TUNER_TA_DAB, AudioSources::NAVI_SPEECH, AudioSources::PHONE_1, AudioSources::PHONE_OUTBAND_RING, AudioSources::MUTE_PIN, AudioSources::MUTE_AUDIO_OFF, AudioSources::MUTE_LIMITED_SYSTEM,SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_DIAGNOSIS, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
      /*RULES*/ { AudioSources::MUTE_SYSTEM, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_SYSTEM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
      /*RULES*/ {SRC_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_ABORT(AudioSources::SPI_SPEECHRECOGNITION), ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_PIN, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
      /*RULES*/ {AudioSources::MUTE_SYSTEM, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*PUSH */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*POP  */ {ACTION_END},           //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
      /*MIX  */ {SRC_END}},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_LIMITED_SYSTEM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
       /*RULES*/ {AudioSources::PHONE_1, AudioSources::PHONE_OUTBAND_RING, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, AudioSources::MUTE_SYSTEM, SRC_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MEDIA_IPOD_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MEDIA_USB_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MEDIA_PLAYER, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerDynamic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::TUNER_XM, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_XMTUN), clStackRules::typeBg, clStackRules::groupRadio, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::SDS_SPEECHRECOGNITION, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_VRU), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::MUTE_SYSTEM, AudioSources::PHONE_1, AudioSources::PHONE_OUTBAND_RING, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_PIN, AudioSources::TUNER_TA_FM, AudioSources::TUNER_TA_DAB, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::SPI_SPEECHRECOGNITION), ACTION_WAIT_FOR(AudioSources::SPI_SPEECHRECOGNITION), ACTION_ABORT(AudioSources::NAVI_SPEECH),ACTION_WAIT_FOR(AudioSources::NAVI_SPEECH),ACTION_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::MUTE_AUDIO_OFF, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
       /*RULES*/ {AudioSources::SMS_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::NAVI_SPEECH, AudioSources::PHONE_1, AudioSources::MUTE_PIN, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::SPI_SPEECHRECOGNITION , AudioSources::SDS_SPEECHRECOGNITION, AudioSources::PHONE_OUTBAND_RING, AudioSources::SPI_SPEECHRECOGNITION, SRC_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 25
   {AudioSources::SMS_SPEECH, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_SMS), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH,  AudioSources::MUTE_SYSTEM, AudioSources::PHONE_1, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, AudioSources::PHONE_OUTBAND_RING, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::NAVI_SPEECH), ACTION_WAIT_FOR(AudioSources::NAVI_SPEECH), ACTION_END},        //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 26
   {AudioSources::TUNER_TA_DAB, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_DAB_TA), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ { AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::PHONE_1, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_AUDIO_OFF,  AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, AudioSources::PHONE_OUTBAND_RING, SRC_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 27
   {AudioSources::SPI_ENTERTAIN, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_SPI_MAIN), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 28
   {AudioSources::SPI_INFO, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_SPI_MIX), clStackRules::typeMix, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::MUTE_SYSTEM),ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 29
   {AudioSources::SPI_PHONE, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_SPI_PHONE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {NOT(AudioSources::MUTE_AUDIO_OFF), SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 30
   {AudioSources::SPI_SPEECHRECOGNITION, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_SPI_VR), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {AudioSources::MUTE_VOLTAGE, AudioSources::MUTE_NO_AUD_DEV, AudioSources::NAVI_SPEECH, AudioSources::MUTE_SYSTEM, AudioSources::PHONE_1, AudioSources::MUTE_LIMITED_SYSTEM, AudioSources::MUTE_PIN, AudioSources::SDS_SPEECHRECOGNITION, AudioSources::SPI_SPEECHRECOGNITION, AudioSources::PHONE_OUTBAND_RING, SRC_END},      //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::NAVI_SPEECH), ACTION_WAIT_FOR(AudioSources::NAVI_SPEECH), ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 31
   {AudioSources::MEDIA_DB_PLAYER, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 32
   {AudioSources::PHONE_OUTBAND_RING, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CUE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerStatic, 5, TRUE, NULL,
       /*RULES*/ {NOT(AudioSources::MUTE_AUDIO_OFF), SRC_ALL, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*PUSH */ {ACTION_ABORT(AudioSources::NAVI_SPEECH), ACTION_WAIT_FOR(AudioSources::NAVI_SPEECH), ACTION_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 33
   {AudioSources::MUTE_VOLTAGE, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
          /*RULES*/ { AudioSources::MUTE_NO_AUD_DEV, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
       /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 34
   {AudioSources::MUTE_NO_AUD_DEV, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupInternal, clStackRules::registerNone, 5, TRUE, NULL,
          /*RULES*/ { AudioSources::MUTE_VOLTAGE, SRC_END},     //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*MIX  */ {SRC_END}},         //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
    {AudioSources::SOURCE_MEDIA, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
           /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
    {AudioSources::PHONE_BTAUDIO, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_BT_AUDIO), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerDynamic, 5, TRUE, NULL,
           /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

    {AudioSources::MEDIA_BTAUDIO_1, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
           /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   {AudioSources::INTERNET_APPS, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_CPRA2), clStackRules::typeBg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
          /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

    {AudioSources::MICROPHONE, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_MIC), clStackRules::typeFg, clStackRules::groupMedia, clStackRules::registerStatic, 5, TRUE, NULL,
           /*RULES*/ {SRC_ALL, SRC_END},    //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
           /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical

   //srcID : 43
   // ****************************************************************************
   // * THIS MUST BE THE LAST ENTRY - ELSE THERE WILL BE UNDETERMINED BEHAVIOR *
   // ****************************************************************************
   {AudioSources::LAST, static_cast<tU16>(midw_fi_tcl_e8_AudSource::FI_EN_NONE), clStackRules::typeFg, clStackRules::groupNone, clStackRules::registerNone, 5, TRUE, NULL,
          /*RULES*/ {SRC_END},          //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*PUSH */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*POP  */ {ACTION_END},       //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
          /*MIX  */ {SRC_END}},            //lint !e785 PQM_authorized_multi_262  Intentionally not corrected, reviewed and not critical
};

clStackRules::clStackRules()
{
   m_rules = NULL;
//   m_srcNameIndex = 0;
   m_type = typeBg;
   m_group =groupNone;
}



clStackRules::~clStackRules()
{
   m_rules = NULL;
//   m_srcNameIndex = 0;
   m_group =groupNone;
}

clStackRules::actions_t clStackRules::getPushAction(int index)
{              //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
    if(m_rules)
       return m_rules->pushActions[index];
    else
        return action_abort;
}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical

clStackRules::actions_t clStackRules::getPopAction(int index)
{              //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
    if(m_rules)
       return m_rules->popActions[index];
    else
        return action_abort;
}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical

int clStackRules::ruleIndex(SourceID srcId)
{
   return ruleIndex(srcId.enSourceClass);
}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical


int clStackRules::ruleIndex(AudioSources::enAudioSources srcClass)
{
   int index ;    //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical
   for(index = 0; rules[index].src != AudioSources::LAST; index++) {
      if( rules[index].src == srcClass)
      {
         return index;
      }
   }
   NORMAL_M_ASSERT_ALWAYS();
   return -1;
}     //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical


clStackRules::clStackRules(SourceID srcID) :
    m_rules(&rules[ruleIndex(srcID)])
    , m_type(rules[ruleIndex(srcID)].type)
    , m_group(rules[ruleIndex(srcID)].group)
    , m_srcReg(rules[ruleIndex(srcID)].sourceRegistration)
    , m_availabilityTimeout(rules[ruleIndex(srcID)].availabilityTimeout)
    , m_autoPlay(rules[ruleIndex(srcID)].autoPlay)
{}

bool clStackRules::setRules(SourceID srcID)
{
   int index;     //lint !e578 PQM_authorized_multi_265  Intentionally not corrected, reviewed and not critical

   /* get rule index */
   index = ruleIndex(srcID);
   if (index == -1) return false;

   /* set the individual rules */
   m_rules = &rules[index];
   /* set the type */
   m_type = rules[index].type; //sources[m_srcNameIndex].type;
   // set the group
   m_group = rules[index].group; //sources[m_srcNameIndex].group;
   m_srcReg = rules[index].sourceRegistration;
   m_autoPlay = rules[index].autoPlay;
   m_availabilityTimeout = rules[index].availabilityTimeout;
   return true;
}



clStackRules::allow_t clStackRules::allowOnTop(AudioSources::enAudioSources enSrcId)
{
   int i;

   if( NULL != m_rules)
   {
      for(i=0; m_rules->allows[i] != SRC_END; i++) {


         /* source allows a particular source (in general) */
         if (MASK(m_rules->allows[i]) == enSrcId) {

            /* source wants to kick the source out */
            if (CHECK_KICK(m_rules->allows[i])) return kicked;


            /* but this source is flagged NOT - so disallow */
            if (CHECK_NOT(m_rules->allows[i])) return disallowed;

            /* not flagged with NOT - allow */
            else return allowed;
         }

         /* source allows all other sources? */
         if (MASK(m_rules->allows[i]) == SRC_ALL) {
            return allowed; /* allow */
         }

         /* source group in general? */
         if (MASK(m_rules->allows[i]) == m_rules->type) {
            return allowed;
         }
      }
   }

   /* not found, disallow */
   return disallowed;
}        //lint !e1762 PQM_authorized_multi_264  Intentionally not corrected, reviewed and not critical



}

